#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <string.h>

#include "labexam.h"


int sum_of_digits(const char* str) {
  int sum = 0;
  while (*str) {
    if (*str >='0' && *str<='9')
      sum += *str-'0';
    str++;
  }
  return sum;
}


int* duplicate_values(const int* ar, int n) {
  int* ret = malloc(2*n*sizeof(int));
  for (int i=0; i<n; i++) {
    ret[2*i] = ar[i];
    ret[2*i+1] = ar[i];
  }
  return ret;
}

int LL_filter(LL_t* list, bool (*pred)(int)) {
  if (list==NULL)
    return 0;
  
  int count = 0;
  node_t* current = list->head;
  node_t* previous = NULL;
  while (current) {
    if (!pred(current->data)) { // need to remove the node
      count++;
      if (current==list->head) {  // handle the case of cur is the head of the list
        LL_remove_from_head(list);
        current = list->head;
      }
      else {
        previous->next = current->next;
        LLnode_free(current);
        current = previous->next;
      }
    }
    else {
      previous = current;
      current = current->next;
    }
  }
  return count;
}


