# instructions:
# 1) place this file in the folder HW-grading
# 2) download submissions from coursys
# 3) unzip the submissions into HW-grading/submissions
# That is, Igor's submission will be under HW-grading/submissions/ishinkar/assignment1.c
# 4) Place all other files (test1.c, test_assignment1.c) under HW-grading/tests
# 
# the script will copy HW-grading/submissions/igors/assignment1.c
# and all test cases to the folder tmp/igors
# and run all test cases one after another
# the number of test cases is specified in the va

# *** IF RUNNING THE SCRIPT MORE THAN ONCE, REMEMBER TO DELETE tmp and grades.scv BEFORE EACH RUN ***

import numpy as np
import pandas
from glob import glob
import sys
import os
import shutil
import subprocess
import signal
import pandas as pd

#####################
submitted_file = "labexam.c"
orig_test_file = "test_cases.c" # this test file was provided with the assignemnt
csv_file = "grades_lab-203-204.csv"
additional_files = ""
num_test_cases = 20
timeout = 8 #seconds
#####################

def points_per_test_case(id):
    return 1 

def slack(hour):
    return hour.startswith('0:') or hour.startswith('1:')

def parse_late(s):
    print("LATE: " + s, end='')
    t = s.split(' ')[2]
    if ':' in t: # t is hours:minutes:seconds
        print("late = " + t)
        if slack(t):
            penalty = 0
        else:
            penalty = 10
    else: # t = days
        h = s.split(' ')[4]
        print("t = " + t)
        print("h = " + h)
        if t == '1':
            if slack(h):
                penalty = 10
            else:
                penalty = 20
        elif t == '2' and slack(h):
            penalty = 20
        else:
            penalty = 100
    return penalty

marks = dict()
student_ids = glob(f"submissions/*")
student_ids.sort()
student_ids = [x.split('/')[-1] for x in student_ids]

# keeping just the student names
print("********************")
print(f'total number of students {len(student_ids)}')
print("********************")

for name in student_ids:
    print("__________________________")
    print(f"processing {name}...")
    student_folder = glob(f"submissions/{name}/*.*")
    files = [x.split('/')[-1] for x in student_folder]
    late_penalty = 0
    if "LATE.txt" in files:
        # parse LATE.txt for late date
        late_file = open(f"submissions/{name}/LATE.txt")
        s = late_file.readline()
        s = late_file.readline()
        s = late_file.readline()
        late_penalty = parse_late(s)

    print(f"late penalty = {late_penalty}%")        
    # prepare files
    cwd = f'tmp/=={name}'
    shutil.copytree(f"tests", cwd)
    shutil.copy(f"submissions/{name}/{submitted_file}", f"{cwd}/{submitted_file}")
#    shutil.copytree(f"lib", f"{cwd}/lib") # copy more files if needed
    

    marks[name] = dict()

    marks[name]['Userid'] = name
    marks[name]['Penalty'] = late_penalty
    marks[name]['Tests passed'] = 0
    marks[name]['Grade'] = 0

    count_pass = 0
    grade = 0

    compile_line = f"gcc -Wall -std=c99 -o run_test_orig {orig_test_file} {submitted_file} {additional_files}"
#    print(compile_line)
    make_command = subprocess.run([f"{compile_line}"], cwd=cwd, capture_output=True, text=True, timeout=timeout, shell=True)
    if(make_command.returncode==0):
        marks[name]['Compiled'] = 'True'
        marks[name]['compile_error'] = make_command.stdout
        # run test cases
        for id in range(1,num_test_cases+1):
            test_id = f"{id:02d}"
            print(f'Test{test_id}...')
            try: 
                compile_line = f"gcc -Wall -std=c99 -o run_test{test_id} test{test_id}.c {submitted_file} {additional_files}"
#                print(compile_line)
                subprocess.run([compile_line], cwd=cwd, capture_output=True, text=True, timeout=timeout, shell=True)
            except:
                # timed out
                print(f"Test{test_id} COMPILATION FALIED!")
                marks[name][f'Test{test_id}'] = 0
                marks[name][f"err_test{test_id}"] = "COMPILATION FALIED"
                continue

            outs=None
            errs=None
            run_test = subprocess.Popen([f"./run_test{test_id}"], start_new_session=True, cwd=cwd, text=True, shell=True, stdout=subprocess.PIPE, stderr=subprocess.PIPE)
            try:
                outs, errs = run_test.communicate(timeout=timeout)
                if(run_test.returncode!=0):
                    # runtime error
                    print(f'Test{test_id} RUNTIME ERROR')
                    marks[name][f'Test{test_id}'] = 0
                    marks[name][f"err_test{test_id}"] = "RTE: " + errs[:150]
                else:
                    output = outs.split('\n')[:-1]
                    flag = 'None'
                    for q in output:
                        err = ""
                        if 'ERROR' in q:
                            flag = 'False'
                            err += "ERROR: " + q[:150]
                            print("ERROR: " + q)
                        elif 'ok' in q and 'ERROR' not in q and flag != 'False':
                            flag = 'True'
    #                    else:
    #                        printf("unexpected text:" + q)


                    if flag=='True':
                        marks[name][f'Test{test_id}'] = 1
                        marks[name][f"err_test{test_id}"] = "ok"
                        count_pass = count_pass+1
                        grade += points_per_test_case(id)
                        print(f'Test{test_id} PASS')
                    else:
                        marks[name][f'Test{test_id}'] = 0
                        marks[name][f"err_test{test_id}"] = err[:150]
                        print(f'Test{test_id} FAIL')

            except:
                # timed out
                os.killpg(os.getpgid(run_test.pid), signal.SIGTERM)
                print(f'Test{test_id} TIMED OUT!')
                marks[name][f'Test{test_id}'] = 0
                marks[name][f"err_test{test_id}"] = "TIME OUT"
                continue


    else:
        marks[name]['Compiled'] = 'False'
        marks[name]['compile_error'] = make_command.stderr
        print(name + " COMPILE ERROR! :: " + make_command.stderr)

    print(name + ": Tests passed:: "+ str(count_pass))
    marks[name]['Tests passed'] = count_pass
    print(name + ": Grade:: "+ str(grade))
    marks[name]['Grade'] = grade
    print("__________________________")

dataframe = pd.DataFrame.from_dict(marks, 'index')
dataframe = dataframe.reindex(sorted(dataframe.columns), axis=1)
dataframe.to_csv(os.getcwd().split("/")[-1] + "_" + csv_file)


