#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Q1
int square_cube(int a, int b) {
  if (a>b)
    return a*a*a + b*b;
  else
    return a*a + b*b*b;
}


// Q2
void rotate3(int* a,int* b,int* c)
{
  int tmp=*a;
  *a = *b;
  *b = *c;
  *c = tmp;
}


// Q3
int digits_to_zero(char* str) {
  int count=0;
  int i = 0;
  while (str[i] != 0) { // same as str[i] != '\0'
    if(str[i]>='0' && str[i]<='9' ) {
      count++;
      str[i]='0';
    }
    i++;
  }
  return count;
}

// helper function computing absolute value for Q4
int get_abs(int n) {
  return n>=0 ? n : -n;
}


// Q4
int max_abs(const int* arr, int len)
{
  int current_abs = get_abs(arr[0]);
  int max = current_abs;
  for(int i=1;i< len;i++) {
    current_abs = get_abs(arr[i]);
    if(current_abs > max)
      max = current_abs;
  }
  return max;
}


// Q5
char* mult_number_by_digit(const char* num, int digit) {
  if (digit == 0) {
    char* res = malloc(2);
    res[0] = '0'; res[1] = 0;
    return res;
  }

  // digit != 0
  size_t n = strlen(num);
  // allocate string for the result
  // +1 for string terminator and +1 in case we need an extra digit
  char* res = (char*) malloc(n+2);

  // string terminator
  res[n+1] = '\0';

  // do long multiplication
  int carry = 0;
  int i;
  for(i=n-1;i>=0;i--) {
    int mult_digits = digit*(num[i] - '0');
    res[i+1] = '0' + ((mult_digits + carry)  % 10);
    carry = (mult_digits+carry) / 10;
  }
  res[0] = '0' + carry;

  // if res has leading zeros, need to shift everything one space to the left
  // for example, if res=['0','1','2','\0'], we change it to res=['1','2','\0','\0']
  if (res[0] == '0')
    memmove(res, res+1, n+1);

  return res;
}
