def get_max_number_sort(lst):
    s = sorted(lst)
    s.reverse()     # here s = [8, 6, 4, 4, 1, 0, 0]

    result = ""
    for digit in s:
        result = result + str(digit)
    return result

    # could use this one liner instead
    # return "".join(str(d) for d in s)    

def get_max_number(lst):

    # count_digits[0] will sort the number of zeros in lst
    # count_digits[1] will sort the number of ones in lst
    count_digits = [0] * 10
    for d in lst:
        count_digits[d] += 1

    if count_digits[0] == len(lst): # all zeros
        return "0"
    
    result = ""
    for i in range(9,-1,-1): # i runs 9,8,7,6,5,4,3,2,1,0
        result += str(i)*count_digits[i]
    return result

    # could use this one liner instead
    # return "".join(str(i)*count_digits[i] for i in range(9,-1,-1))    


digits = [0, 6, 0, 4, 8, 4, 1]  # expect the answer to be "8644100"
max_num = get_max_number(digits)
print(max_num)
