#include <stdio.h>

void swap_wrong(int a, int b) {
    printf("before: a = %d b = %d\n", a,b);
    int origA = a;
    int origB = b;

    b = origA;
    a = origB;
    printf("after: a = %d b = %d\n", a,b);
}

// we need pointers for swap
void swap2(int* a, int* b) {
    int origA = *a;
    int origB = *b;

    *a = origB;
    *b = origA;
}

// we need pointers for swap
void swap(int* a, int* b) {
    int tmp = *a;
    *a = *b;
    *b = tmp;
}

// we need pointers for swap
void swap0(int* a, int* b) {
    *a = *a+*b;
    *b = *a-*b;
    *a = *a-*b;
}

int main() {
    int x = 5;
    int y = 7;
    printf("x = %d, y = %d\n", x, y); // x = 5 y = 7

    swap_wrong(x,y);
    printf("\nafter wrong swap: x = %d, y = %d\n", x, y); // x = 7 y = 5

    swap(&x, &y); // send the address of x and y
    printf("after swap: x = %d, y = %d\n", x, y); // x = 7 y = 5

    return 0;
}
