#include <stdio.h>
// average gets an array ar of a given length n
// and returns the average of the elements in the array
// assumption: the size of the array is at least n
float average(const float* ar, int n) {
  float sum = 0;

  for(int i=0; i < n; i++)
    sum += *(ar+i); // same as ar[i]
    // ar - pointer to ar[0]
    // ar+i - pointer to ar[i] -- it really points to memory ar + i*sizeof(float)
    // *(ar+i) - dereferencing of ar+i
    //
    // let's say float is 4 byte
    //  ar[0]  ar[1]    ar[2]
    //   |       |       |
    //   v       v       v
    //  [ | | | | | | | | | | | ]
    //
    // ar+2 really points to ar+8 in the memory (because they know that ar is array of floats) 
  return sum/n;
}

int main() {
  float arr[6] = {0.2, 4.5, 7.1, 12.7, 4, -1.2};
  float avg;

  // printf("address of arr[0] is %p\n", arr);
  // printf("address of arr[1] is %p\n", arr+1);
  // printf("address of arr[2] is %p\n", arr+2);

  avg = average(arr, 6);
  printf("average of arr = %.3f\n", avg);

  avg = average(arr+2, 4);
  printf("average of the ar[2...5] = %.3f\n", avg);

  float* ptr = arr; // points to the same as arr 
  avg = average(ptr, 6);
  printf("average of arr = %.3f\n", avg);

  if (ptr == arr)
    printf("ptr == arr\n");
  else
    printf("ptr != arr\n");

  return 0;
}
