#include <stdio.h>

// if a[0...length-1] is equal to b[0...length-1] returns -1
// otherwise, returns first index where a[i] != b[i]
int compare(const int a[], const int b[], int length) {
    if (a==b) // same array
        return -1;

    int i = 0;
    while (i < length) {
        if (a[i] != b[i])
            return i;
        i++;
    }
    return -1; // -1 means they are equal
}

int main() {

    int a1[6] = {1,2,3,4,5,6};
    const int a2[6] = {1,2,3,4,8,6};
    int a3[6]       = {1,2,3,4,8,6};

    // printf("a1 = %p, address of a1[0] = %p \n\n", a1, &a1[0]);

    // printf("a1 = %p\n",a1);
    // printf("a2 = %p\n",a2);
    // printf("a3 = %p\n",a3);
    printf("----\n");

    if (a2 == a3)
        printf("USING==  The arrays a2 and a3 are the same\n");
    else
        printf("USING==  The arrays a2 and a3 are NOT the same\n");

    int comp = compare(a1, a2, 4);
    if (comp == -1)
        printf("The arrays a1 and a2 are equal in the first 4 elements\n");
    else
        printf("The arrays a1 and a2 differ in position %d\n", comp);

    comp = compare(a1, a3, 6);
    if (comp == -1)
        printf("The arrays a1 and a3 are equal in the first 6 elements\n");
    else
        printf("The arrays a1 and a3 differ in position %d\n", comp);

    comp = compare(a2, a3, 6);
    if (comp == -1)
        printf("The arrays a2 and a3 are equal\n");
    else
        printf("The arrays a2 and a3 differ in position %d\n", comp);

    return 0;
}

