#include <stdio.h>

// copies the first n values from src to dest
// Assumption: the sizes of both arrays are at least n
//
// note that int* dest means a pointer to the beginning of the array
void copy_array(int* dest, const int* src, int n) {
    for(int i=0; i < n; i++)
        dest[i] = src[i];

    // src[0] = 4;    const prevent us from changing the values
}

// returns -1 if the two arrays are equal in the first n indices
// otherwise, returns the first index where the array differ
// Assumption:  the sizes of both arrays are at least n
int compare_arrays(const int* array1 , const int* array2, int n) {
    if (array1 == array2) // check if both point to the same array
        return -1;
    
    for (int i=0; i < n ;i++)
        if (array1[i] != array2[i])
            return i;

    return -1; // if reached here, the arrays have same values
}

int main() {
    int array1[6] = {0, 2, -4, 12, 8, 1};
    int array2[16] = {1, 2, 3, 4, 5}; // the length of array2 is 16, but only the first 5 elts are initialized

    if (compare_arrays(array1, array2, 6) == -1)
        printf("The arrays are equal\n");
    else
        printf("The arrays are not equal\n");

    copy_array(array2, array1, 6);

    if (compare_arrays(array1, array2, 6) == -1)
        printf("The arrays are equal\n");
    else
        printf("The arrays are not equal\n");
    // arrays are equal here

    printf("-----------------\n");

    array2[4] = 25;
    if (compare_arrays(array1, array2, 6) == -1)
        printf("The arrays are equal\n");
    else
        printf("The arrays are not equal\n");

    if (compare_arrays(array1, array2, 4) == -1)
        printf("The arrays are equal in the first 4 indices\n");
    else
        printf("The arrays are not equal in the first 4 indices\n");



    int* int_ptr = array1;
    if (compare_arrays(array1, int_ptr, 6) == -1)
        printf("arrays are equal \n");


    return 0;
}
