/* Implementations of str_len, str_cpy str_cat without
 * using the stardard library string.h
 */
#include <stdio.h>


// comparing two strings
int str_cmp(const char* s1, const char* s2) {
  // if they are the same string in the memory, return 0
  if (s1 == s2)
    return 0;

  int i=0;

  while(s1[i] != 0 && s2[i] != 0) {  // same as s1[i] != '\0'...
    if (s1[i] != s2[i])
      return (s1[i] - s2[i]);
    else
      i++;
  }
  // one of the strings has been traversed
  return s1[i] - s2[i];
}


// Returns the length of the string
// Assumption: the string has a null terminator
int str_len(const char* str) {
    int i = 0;
    while (str[i] != '\0') // str[i] != 0
      i++;

    return i;
}
// what if str doesn't have '\0'?
//      str
//       |
//       v
//   Hello@abcds,n123123*!@)(*) lkasx!@$#$^G$% [CHROME'S MEMORY 
// the function will either find a "random" '\0' in the memory or
// will reach memory it shouldn't access and will crash




// Copies the string pointed by src into the array pointed by dest
// including the terminating null character.
// Returns pointer to dest.
// We assume that the size of dest is at least the length of src + 1.
char* str_cpy(char* dest, const char* src) {
    int i = 0;
    while (src[i] != '\0') {
        dest[i] = src[i];
        i++;
    }
    dest[i] = 0; // remember to put '/0' in the end
    return dest;
}

// Appends a copy of the source string to the destination string.
// Returns pointer to dest.
// We assume that the size of dest is large enough
// to contain the concatenated string, and that the strings do not overlap.
char* str_cat(char* dest, const char* src) {
    int i = 0;
    while (dest[i] != '\0')
        i++; // compute strlen(dest)
    str_cpy(dest+i, src);
    return dest;
    // if before dest = "ABC", src="XYZ"
    // then after, dest = "ABCXYZ"
}


int main() {
  	char* word1 = "Hello";  // immutable string
    char word2[6] = {'H', 'e', 'l', 'l', 'o', 0};
    char word3[] = "Hello";

    printf("word1 = %s\n", word1);
    printf("word2 = %s\n", word2);
    printf("word3 = %s\n\n", word3);

    printf("strlen(word2) = %d\n\n", str_len(word2));

    // word1[3] = 'p'; // no! word1 is immutable
    // printf("word1 = %s\n", word1);


    // word2[3] = 'p';
    // word2[4] = 0;  // same as '\0' 
    // printf("word2 = %s\n", word2); // now word2 is {'H', 'e', 'l', 'p', 0, 0};

    // word3[1] = 0;
    // word3[0] = '3';
    // // word3 = {'3', 0, 'l', 'l', 'k', '\0'}
    // printf("word3 = %s\n", word3);

    // word3[0] = '3';
    // word3[1] = '4';
    // word3[2] = '5';
    // word3[3] = '6';
    // word3[4] = '7';
    // // word3 = {'3', '4', '5', '6', '7', '\0'}
    // printf("word3 = %s\n", word3);

    char* a = "These";
    char b[40];

    printf("The length of \"%s\" is %d\n", a, str_len(a));

    str_cpy(b, a);
    printf("b = \"%s\"\n", b);

    if (a == b)
      printf("a == b\n");
    else
      printf("a != b\n"); // WHY?


    str_cat(b, " strings");
    printf("b = \"%s\"\n", b); // use \" to print quotation marks

    str_cat(b, " are");
    printf("b = \"%s\"\n", b); // use \" to print quotation marks

    printf("b = \"%s\"\n", str_cat(b, " concatenated.")); // use \" to print quotation marks

    return 0;
}
