#include <stdio.h>
#include <stdlib.h>

int* get_array_10_WRONG() {
  int ret[10]; // incorrect! this is a local variable, cannot be returned

  for (int i = 0; i < 10; i++)
    ret[i] = i;

  return ret;
}

int* get_array_EVEN_WORSE(int n) {
  int ret[n]; // incorrect! this is a local variable, cannot be returned
  // also DO NOT USE VLAs

  for (int i = 0; i < n; i++)
    ret[i] = i;

  return ret;
}


int* get_array(int n) {
  int* ret = (int*) malloc(n * sizeof(int));
  if (ret == NULL) // something went wrong
    return NULL;

  for (int i = 0; i < n; i++)
    ret[i] = i;

  return ret;
}


int main() { 
  int size = 10;

  int* a = get_array(size);
  if (a == NULL) {
    printf("malloc failed");
    return -1;
  }    

  for (int i = 0; i < size; i++)
    printf("a[%d] = %d\n", i, a[i] );

  int* b = a;
  free(a); // when we are done, release the memory
  // do not free(b) -- it will cuase double free

  return 0;
}
