#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void init_arr(int* a, int n) {
  for (int i = 0; i < 10; i++)
    a[i] = i;
}

void print_arr(const int* a, int n) {
  for (int i = 0; i < n; i++)
    printf("%4d ", a[i]);
  printf("\n");  
}

int main() { 
  // example of overlapping blocks of memory
  int a[10];
  init_arr(a,10);

  printf("---orig a------\n");
  print_arr(a,10);
  printf("---------\n");

  init_arr(a,10);
  memcpy(&a[0], &a[2], 5*sizeof(int)); // copy 5 ints
  print_arr(a,10);

  init_arr(a,10);
  memcpy(&a[2], &a[0], 5*sizeof(int)); // copy 5 ints
  print_arr(a,10);

  // memcpy(&a[0], &a[2], 5*sizeof(int)); // copy 5 ints
  //         |      |
  //         v      V
  //    a = [0,  1, 2, 3, 4, 5,6,7,8..]

  // HW: check what memcpy does and what memmove does in these two cases
  // (1)
  //  memcpy(&a[0], &a[2], 5*sizeof(int));
  //  memmove(&a[0], &a[2], 5*sizeof(int));
  // (2)
  //  memcpy(&a[2], &a[0], 5*sizeof(int));
  //  memmove(&a[2], &a[0], 5*sizeof(int));

  return 0;
}
