#include <stdio.h>
#include <stdlib.h>

int* read_array(int n) {
  //int arr[n];
  // printf("read: address of arr: %p\n", arr);
  // WRONG!! this cannot be returned - because ***arr is a local variable***
  // and will not compile on some compilers, the size should be know in compile time

  int* arr = (int*) malloc(n*sizeof(int)); // create arr on the heap
  if (arr==NULL) {
    printf("malloc failed\n");
    return 0;
  }

  printf("Enter the %d numbers\n", n);
  for (int i  = 0; i < n; i++)
    scanf("%d", arr+i); // arr+i is the address of arr[i], same as &arr[i]

  return arr;
}

void print_rev_array(int* arr, int n) {
  printf("The list in reverse order:\n");
  for (int i = n-1; i>=0; i--)
    printf("%4d ", arr[i]);
  printf("\n");
}

int main() {
  int n; // length of the array
  printf("Please enter the size of the array\n");
  scanf("%d", &n);

  int* arr = read_array(n);
  printf("main: address of arr %p\n", arr);

  print_rev_array(arr, n);

  free(arr); // don't forget to free arr in the end
 
  return 0;
}
