#include <stdio.h>
#include <string.h>


// Appends a copy of the source string to the destination string.
// Returns pointer to dest.
// We assume that the size of dest is large enough
// to contain the concatenated string, and that the strings do not overlap.
char* strcat2(char* dest, const char* src) {
    int n = strlen(dest);
    strcpy(dest+n ,src);
    return dest;

    // this also works
    // return strcpy(dest+strlen(dest), src);

    // if before dest = "ABCD", src="XYZ"
    // then after, dest = "ABCDXYZ"
    // assumption the length of the array dest is at least 8 
}

// int main() {
//     char* a = "These";
//     char b[40]; // b = ['@','X',0,...]

//     printf("The length of \"%s\" is %d\n", a, strlen(a));

//     strcpy(b, a);                 // b = "These"
//     strcat(b, " strings");        // b = "These strings"
//     strcat(b, " are");            // b = "These strings are"
//     strcat(b, " concatenated.");  // b = "These strings concatenated."
//     printf("b = \"%s\"\n", b);

//     return 0;
// }

int main() {
    char* a = "These";
    char b[40]; // b = ['@','X',0,...]

    printf("The length of \"%s\" is %d\n", a, strlen(a));

    b[0] = 0;                     // b= "" - the empty string
    strcat(b, a);                 // b = "These"
    strcat(b, " strings");        // b = "These strings"
    strcat(b, " are");            // b = "These strings are"
    strcat(b, " concatenated.");  // b = "These strings concatenated."
    printf("b = \"%s\"\n", b);

    return 0;
}
