#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>

// see https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797

void default_color() {
  printf("\033[0;39m");  // set color to default
}

void green() {
  printf("\033[0;32m");  // set color to green
}

void red() {
  printf("\033[1;31m");  // set color to red bold
}

void countdown() {
  struct timespec ts;
  ts.tv_sec = 0;          // seconds
  ts.tv_nsec = 100000000; // 100 milliseconds (0.1 second)

  for(int i=0;i<=100;i++) {
    if (i==30)
      green();
    if (i==90)
      red();
    // printf("\x1B[0G"); // move to column 0
    // printf("%3d%%", i); // print 25%
    printf("\x1B[1G%3d%%", i);
    nanosleep(&ts,NULL);
  }
  default_color();
  printf("\nDONE\n");
}

int main() {
  printf("12345678");
  printf("\x1B[3G"); // move to column 3
  printf("ABC\n");
  // the result on the screen will be "12ABC678"

  printf("qwerty\n");
  printf("xyz\n");
  printf("erasing everything before ABC... in 4\n");
  printf("\x1B[1A\x1B[38G");
  sleep(1);
  printf("\x1B[1D3");
  sleep(1);
  printf("\x1B[1D2");
  sleep(1);
  printf("\x1B[1D1");
  sleep(1);

  printf("\x1B[3F"); // move 3 lines up to the line "12ABC678"
  printf("\x1B[2G"); // move to column 2
  printf("\x1B[1J"); // erase everything before that

  sleep(2);
  printf("\x1B[4E"); // move 4 lines down
 
  return 0;
}