#include <stdio.h>

// usually if we want to have an array height x width
// we just allocate a 1-d array of length height*width
// arr[i][j] = A[i*width+j];

// let's say I want 2x3 array
//[1,2,3]
//[7,8,9]
// what I really do is create a 1d array A = [1,2,3,7,8,9]
//arr[1,1] = A[1*width+1] = A[4] = 8
void print_2d_array(int height, int width, int array[height][width]) {
    int i,j;
    for (i = 0; i < height; i++)
    {
        for (j = 0; j < width; j++)
            printf("%3d ", array[i][j]);
        printf("\n");
    }

}


int main() {

    int a[3][4] = {
        {0, 1, 2, 3},   //  initializers for 0 row
        {4, 5, 6, 7},   //  initializers for 1 row
        {8, 9, 10, 11}   //  initializers for 2 row
    };


    printf("a:\n");
    print_2d_array(3, 4, a);
    printf("\n");


    int b[3][4] = {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};

    printf("b:\n");
    print_2d_array(3, 4, b);
    printf("\n");

    printf("b:\n");
    print_2d_array(2, 6, b);
    printf("\n");

    printf("size of *b = %ld\n", sizeof(*b));

// more subtelties
// this is ok -- it sees 3 items, each item being int[4]
    int c[][4] = {
        {0, 1, 2, 3},   //  initializers for 0 row
        {4, 5, 6, 7},   //  initializers for 1 row
        {8, 9, 10, 11}   //  initializers for 2 row
    };

    // same as 
    int ar[] = {70,80,90,100}; // it sees 4 items

// this does not compile
//    int c[][] = {
//        {0, 1, 2, 3} ,   //  initializers for 0 row
//        {4, 5, 6, 7} ,   //  initializers for 1 row
//        {8, 9, 10, 11}   //  initializers for 2 row
//    };
// because it treats the init line as {0,1,2,3,4,5,6,7,8,9,10,11}
// it doesn't know how long each row is
    return 0;
}
