#include <stdio.h>
#include <stdlib.h>

typedef struct {
  char* name;
  int id;
} person;

// the function creates a struct person as a local var
// the struct contains char* - pointer to name and int - id
// the string with the name is allocated on the heap
person* create_person_wrong() {
  person p;
  p.name = (char*) malloc (21*sizeof(char));
  printf("Enter name (up to 20 chars): ");
  scanf("%s", p.name);

  printf("Enter ID: ");
  scanf("%d", &(p.id));

  return &p; // p is a local variable, cannot return pointer to it as it goes out of scope
}


// the function creates a struct person on heap
// the struct contains char* - pointer to name and int - id
// the string with the name is allocated on the heap
person* create_person()
{
  person* p = (person*) malloc(sizeof(person));
  p->name = (char*) malloc(21*sizeof(char));
  printf("Enter name (up to 20 chars): ");
  scanf("%s", p->name);

  printf("Enter ID: ");
  scanf("%d", &(p->id));

  return p;
}

int main(void) {
  person* someone = create_person();
 
  printf("\n----------------------\n");
  printf("name = %s, id = %d\n", someone->name, someone->id);

  free(someone->name); // release the string before releasing the entire struct
  free(someone);

  return 0;
}