#include <stdio.h>
#include <inttypes.h>

// sizeof(int) is usually 4 bytes
// sizeof(long long) is usually 8 bytes
// but that varies for different machine
// inttypes.h contains types of guaranteed sizes:
// int8_t, int16_t,int32_t, int64_t // signed
// uint8_t, uint16_t, uint32_t, uint64_t // unsigned

int main() {
   // unsigned int with 32 bits representation
    uint32_t x = 4000000000;

    printf("x= %u \n", x); // %u - unsigned int

    // warning! number too large for 4 bytes = 32 bits
    uint32_t y = 543210987654321;
    // too large [00000000,00000001,11101110,00001100,00101001,11110101,00001100,10110001]
 
    printf("y = %llu\n", y);
    // the outputs will be 703925425  [00101001,11110101,00001100,10110001]
    // only the least significant 4 bytes are kept

    uint64_t z = 543210987654321; // 64 bits = 8 bytes - ok
    printf("z = %llu\n", z);

    return 0;
}

