#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <time.h>
#include <conio.h> // works in windows

// see https://gist.github.com/fnky/458719343aabd01cfb17a3a4f7296797

void default_color() {
  printf("\033[0;39m");  // set color to default
}

void green() {
  printf("\033[0;32m");  // set color to green
}

void red() {
  printf("\033[1;31m");  // set color to red bold
}

void countdown() {
  struct timespec ts;
  ts.tv_sec = 0;          // seconds
  ts.tv_nsec = 100000000; // 100 milliseconds (0.1 second)

  for(int i=0;i<=100;i++) {
    if (i==30)
      green();
    if (i==90)
      red();
    // printf("\x1B[1G");  // move to the beginning of the line
    // printf("%3d", i);   // print number
    // printf("%%");       // print % sign
    printf("\x1B[1G%3d%%",i); // -- all in one line
    nanosleep(&ts,NULL);
  }
  default_color();
  printf("\nDONE\n");
}

void testing_esc_codes() {
  printf("12345678");
  getch();
  printf("\x1B[3G"); // move to column 3
  getch();
  printf("\033[1;31m"); // red bold
  printf("ABC");
  printf("\033[0;39m"); // default font
  getch();
  printf("\n");
  // the result on the screen will be "12ABC678" with ABC in red

  printf("line 1\n");
  printf("line 2\n");
  printf("erasing everything before ABC... in 4");
  sleep(1);
  printf("\x1B[1D3"); // move one to the left and print 3
  sleep(1);
  printf("\x1B[1D2"); // move one to the left and print 2
  sleep(1);
  printf("\x1B[1D1"); // move one to the left and print 1
  sleep(1);

  printf("\x1B[3F"); // move 3 lines up to the line "12ABC678"
  printf("\x1B[2G"); // move to column 2
  printf("\x1B[1J"); // erase everything before that
  printf("\x1B[1C"); // move 1 step to the right
  sleep(3);
  printf("\x1B[3E"); // move 3 lines down
  printf("\n");
  sleep(3);
}

void move_cursor() {
    printf("move_cursor()... press q to exit\n");

    printf("\x1B[s");

    unsigned char c;
    while(1) {
        c = getch();
        if (c =='q') {
            printf("\x1B[u");
            return;
        }
        else if (c == 0xE0) { // if the first value is esc, read the second char
            switch(getch()) { // the real value 
                case 'H':
                    printf("\x1B[1A");
                    // printf("UP\n");
                    break;
                case 'P':
                    printf("\x1B[1B");
                    // printf("DOWN\n");
                    break;
                case 'M':
                    printf("\x1B[1C");
                    // printf("RIGHT\n");
                    break;
                case 'K':
                    printf("\x1B[1D");
                    // printf("LEFT\n");
                    break;
                case 'I':
                    printf("PG UP\n");
                    break;
                case 'Q':
                    printf("PG DOWN\n");
                    break;
                case 'G':
                    printf("HOME\n");
                    break;
                case 'O':
                    printf("END\n");
                    break;
                case 'R':
                    printf("INS\n");
                    break;
                case 'S':
                    printf("DEL\n");
                    break;
                default:
                    printf("CHAR %c, HEX = %2x, DEC = %d\n", c, c, c);
                    break;
            }
        }
        else if (c == '\r')     // ENTER
            printf("\n");
        else
            printf("%c",c);
    }
}


int main() {
  move_cursor();
  return 0;
}