#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define HEIGHT 10
#define WIDTH 10

void printboard(int a[HEIGHT][WIDTH]) {
  char* symbols[2] = {".", "\x1b[1;31m@\x1b[1;39m"};
  // symbols[0] is a dot
  // symbols[1] is a RED @

  for (int i = 0; i < HEIGHT; i++) {
    for (int j = 0; j < WIDTH; j++)     // print the i'th row
      printf("%s", symbols[a[i][j]]);
    printf("\n");
  }
}

int count_neighbours(int a[HEIGHT][WIDTH], int i, int j) {
  int count = 0;
  for (int x = i-1; x <= i+1; x++)
    for (int y = j-1; y <= j+1; y++)
      if (x>=0 && x<HEIGHT && y>=0 && y<WIDTH)
        count += a[x][y];

  return count - a[i][j];
}

void evolve (int a[HEIGHT][WIDTH]) {
  int tmp[HEIGHT][WIDTH];
  for (int i = 0; i < HEIGHT; i++) {
    for (int j = 0; j < WIDTH; j++) {
      int count = count_neighbours(a, i,j);
      if (a[i][j]==1 && (count==2 || count==3))
        tmp[i][j] = 1;
      else if (a[i][j]==0 && count==3)
        tmp[i][j] = 1;
      else
        tmp[i][j] = 0;
    }
  }
  memcpy(a, tmp, sizeof(int)*HEIGHT*WIDTH);
}

int main() {
  int board[HEIGHT][WIDTH]; // 0 - dead, 1 - alive
  memset(board, 0, sizeof(int)*HEIGHT*WIDTH);

  board[0][1] = 1; //   @
  board[1][2] = 1; //    @
  board[2][0] = 1; //  @@@
  board[2][1] = 1;
  board[2][2] = 1;

  printboard(board);

  for (int i = 0; i < 20; i++) {
    evolve(board);
    sleep(1);
    printf("\x1B[%dF", HEIGHT); // move HEIGHT lines up
    printboard(board);
  }
  
  return 0;
}
