#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <inttypes.h>


/*
          fib(8)
        /       \
     fib(7)     fib(6)
    /   \       /   \
 fib(6)fib(5) fib(5)fib(4)
 ....
*/
// get a number n >= 0
// returns fib(n)
long long fib(int n) {
  if (n <= 1) // n==0 or 1
    return n;
  else
    return fib(n-1) + fib(n-2);
} 


// get a number n >= 0
// returns fib(n)
long long fib_array(int n) {
  // the array stores fib(i) in array_fib[i]
  // we have n+1 elements to stor fib[0,1,2,...,n]
  long long* array_fib = (long long*) malloc( (n+1) * sizeof(long long));
  if (array_fib == NULL)
    return -1; 
  
  array_fib[0] = 0;
  array_fib[1] = 1;
 
  // populate the array one element at a time from 2 to n
  for (int i = 2; i<=n; i++)
    array_fib[i] = array_fib[i-1] + array_fib[i-2];
  
  // don't forget to free array_fib
  long long res = array_fib[n];
  free(array_fib);

  return res;
} 

// compute fib(n) using formula
long fib_formula(int n)
{
  double base = 1.61803398875; // (sqrt(5)+1)/2 =
  printf("n=%d, ans = %f\n", n, pow(base, n)/sqrt(5));
  return round(pow(base, n)/sqrt(5));
} 

int main() { 

  int n = 40;
  printf("fib-fast(%d)    = %lld\n", n, fib_array(n) );
  printf("fib-slow(%d)    = %lld\n", n, fib(n) );
  printf("fib-formula(%d) = %lld\n", n, fib_formula(n) );

/*
  printf("\n-------\n\n");
  printf("sizeof long long is %lu bytes\n", sizeof(long long)); // maybe try long long
  printf("sizeof uint64_t is %lu bytes\n", sizeof(uint64_t));
  uint64_t huge = 1;
  huge = (huge << 63) - 1;
  printf("huge number = %lld\n", huge);
  printf("trying to add 1 to it...\n");
  huge = huge+1;
  printf("huge number = %lld\n", huge);
*/
  return 0;
}
