#pragma once


#include <MathLib/Vector3d.h>
#include <string>
#include <fstream>
#include <iostream>
#include "../compileconfig.h"
#include <Physics/NullWorld.h>

#ifdef ODE
#include <Physics/ODEWorld.h>
#endif

#ifdef Bullet
#include <Physics/BulletWorld.h>
#endif

#ifdef Vortex
	#include <Physics/VortexWorld.h>
#endif

#undef max
#undef min
#ifdef PhysX
	#include <Physics/PhysXWorld.h>
#endif
#ifdef PhysX3
	#include <Physics/PhysX3World.h>
#endif
//#include <Physics/PhysXWorld.h>

#define LEFT_STANCE 0
#define RIGHT_STANCE 1

/**
	This class is used as a container for all the constants that are pertinent for the physical simulations, the controllers, etc.
*/

class SimGlobals {
public:
	//if this is set to true, then the heading of the character is controlled, otherwise it is free to do whatever it wants
	static int forceHeadingControl;
	//this variable is used to specify the desired heading of the character
	static double desiredHeading;
	//and this is the desired time interval for each simulation timestep (does not apply to animations that are played back).
	static double dt;

	static World* activeRbEngine;

	//temp..
	static double targetPos;
	static double targetPosX;
	static double targetPosZ;

	static double conInterpolationValue;
	static double bipDesiredVelocity;

	static int constraintSoftness;

	static int CGIterCount;
	static int linearizationCount;

	static double rootSagittal;
	static double stanceKnee;
/*
	static double rootLateral;
	static double swingHipSagittal;
	static double swingHipLateral;
	static double stanceAngleSagittal;
	static double stanceAngleLateral;

	static double style;

	static double VDelSagittal;
	static double stepHeight;
	static double stepTime;
	static double duckWalk;
	static double upperBodyTwist;

	static double coronalStepWidth;

	static double COMOffsetX;
	static double COMOffsetZ;
*/

	SimGlobals(void){
	}
	~SimGlobals(void){
	}

	inline static World* getRBEngine(){
		std::string line;
		if (activeRbEngine == NULL){
			std::ifstream myfile("..\\controllerconfig.txt");
			int engine;
			if (myfile.is_open())
			{
				std::getline (myfile,line);
				std::getline (myfile,line);
				char *a=new char[line.size()+1];
				a[line.size()]=0;
				memcpy(a,line.c_str(),line.size());
				engine = atoi(a);
				//delete [] a;

				if(a[0] == 'o' || a[0] == 'O' || a[0] == 'q' || a[0] == 'Q'){
#ifdef ODE
					activeRbEngine = new ODEWorld();
#endif
				} else if(a[0] == 'p' || a[0] == 'P'){
					if(a[1] == '3'){
#ifdef PhysX3
					activeRbEngine = new PhysX3World();
#endif
					} else{
#ifdef PhysX
					activeRbEngine = new PhysXWorld();
#endif
					}
				} else if(a[0] == 'v' || a[0] == 'V'){
#ifdef Vortex
					activeRbEngine = new VortexWorld();
#endif
				} else {
#ifdef Bullet
					activeRbEngine = new BulletWorld();
#endif
				}
			}
			myfile.close();	
		}
		return activeRbEngine;
	}

};
