#include "../compileconfig.h"
#ifdef PhysX3

#include "DebugRenderer3.h"
#if defined(__APPLE__)
#include <GLUT/glut.h>
#else
#include <Include/glut.h>
#endif

void DebugRenderer3::setupColor(PxU32 color) const    
{ 
	PxF32 Blue= PxF32((color)&0xff)/255.0f; 
	PxF32 Green= PxF32((color>>8)&0xff)/255.0f;
	PxF32 Red= PxF32((color>>16)&0xff)/255.0f;
	glColor3f(Red, Green, Blue);
}

void DebugRenderer3::renderData(const PxRenderBuffer& data) const   
{     
	GLboolean lighting = glIsEnabled(GL_LIGHTING);
	if (lighting)
		glDisable(GL_LIGHTING);

	glLineWidth(1.0f);    
	// Render points 
	{        
		PxU32 NbPoints = data.getNbPoints();  
		const PxDebugPoint* Points = data.getPoints();       
		glBegin(GL_POINTS);         
		while(NbPoints--)         
		{             
			setupColor(Points->color); 
			glVertex3fv(&Points->pos.x);        
			Points++;            
		}         
		glEnd();  
	}      
	// Render lines  
	{       
		PxU32 NbLines = data.getNbLines();
		const PxDebugLine* Lines = data.getLines();
		glBegin(GL_LINES);         
		while(NbLines--)      
		{               
			setupColor(Lines->color0);
			//setupColor(230);
			glVertex3fv(&Lines->pos0.x);   
			glVertex3fv(&Lines->pos1.x);     
			Lines++;           
		}          
		glEnd();     
	}       
	// Render triangles      
	{            
		PxU32 NbTris = data.getNbTriangles(); 
		const PxDebugTriangle* Triangles = data.getTriangles();    
		glBegin(GL_TRIANGLES);            
		while(NbTris--)           
		{            
			setupColor(Triangles->color0);    
			glVertex3fv(&Triangles->pos0.x);       
			glVertex3fv(&Triangles->pos1.x);          
			glVertex3fv(&Triangles->pos2.x);         
			Triangles++;          
		}        
		glEnd();     
	}   

	if (lighting)
		glEnable(GL_LIGHTING);
}

#endif