'''
Created on 2009-08-25

Basic controller editor

@author: beaudoin
'''
import sys
sys.path += ['.']

import wx, App, math

movieResolution = (1280,720)
#movieResolution = (996,538)
movieSetup = False # True if we want a movie
glMovie = False    # True if we're only interested in recording the GL canvas
                   # False if we want a "screen cast"

glCanvasSize = wx.DefaultSize
size = wx.DefaultSize
showConsole = True
if movieSetup:
    if glMovie:
        glCanvasSize = movieResolution
    else:
        size = movieResolution
        showConsole = False


app = App.SNMApp("Style Editor", size = size, glCanvasSize=glCanvasSize, showConsole = showConsole)

import UI, Utils, GLUtils, Physics, Core, MathLib, PyUtils
from App import InstantChar, KeyframeEditor

# Create the desired tool sets
toolPanel = app.getToolPanel()
animationToolSet = UI.ToolSets.Animation(toolPanel)
if not movieSetup:
    optionsToolSet = UI.ToolSets.Options(toolPanel)
    optionsToolSet._toolSet.setOpen(False)
cameraToolSet = UI.ToolSets.Camera(toolPanel)
cameraToolSet._toolSet.setOpen(False)
instantChar = InstantChar.Model()
if not movieSetup:
    controllerSnapshotToolSet = UI.ToolSets.SnapshotTree(toolPanel)
    controllerSnapshotToolSet._toolSet.setOpen(False)
    controllerTreeToolSet = UI.ToolSets.ControllerTree(toolPanel)
    controllerTreeToolSet._toolSet.setOpen(False)

glCanvas = app.getGLCanvas()
glCanvas.addGLUITool( UI.GLUITools.CurveEditorCollection )

#from Data.Frameworks import DefaultFramework
#from Data.Frameworks import DanceFramework
#from Data.Frameworks import WalkFramework

#get controller name from configuration file
multiple = False
numchar = 0
f = open('../controllerconfig.txt','r')
line = f.readline()
if (line[0] != 't') :
    #multiple = True
    numchar = int(line.rstrip('\n'))
line = f.readline()
if (line[0] == 'o') :
    if (line[1] == 'q') :
        print "Simulation engine = ODE-quick"
    else:
        print "Simulation engine = ODE"
elif(line[0] == 'p') :
	if(line[1] == '3'):
		print "Simulation engine = PhysX 3.0"
	else:
		print "Simulation engine = PhysX 2.8.4"
elif(line[0] == 'v') :
    print "Simulation engine = Vortex"
else :
    print "Simulation engine = Bullet"
line = f.readline()
print "Simulation time step = %.1f ms"%(float(line.rstrip('\n')) * 1000)
line = f.readline()
while (line[0] == '#'):
    line = f.readline()
controlname = line
print "Controller = "+line.rstrip('\n')
line = f.readline()
print "Speed = "+line.rstrip('\n')
line = f.readline()
print "Duration = "+line.rstrip('\n')
line = f.readline()
print "Width = "+line.rstrip('\n')
f.close()

print "============================================================================"

#####################
## BEGIN Custom for Instant Character
#controller = PyUtils.load( "Characters.BipV3.Controllers.CartoonySneak", character )
#controller = PyUtils.load( "Characters.BipV3.Controllers.ZeroWalk", character )
#controller = PyUtils.load( "Characters.BipV3.Controllers.VeryFastWalk_5-43_0-4", character )
#controller = PyUtils.load( "Characters.BipV3.Controllers.jog_8-76_0-33", character )
#controller = PyUtils.load( "Characters.BipV3.Controllers.run_21-57_0-38_0-10", character )
#controller = PyUtils.load( "Characters.BipV3.Controllers.FastWalk_3-7_0-53", character )
#controller = PyUtils.load( "Temp.Cartoony", character )
#controller = PyUtils.load( "Temp.TipToe", character )

#character.loadReducedStateFromFile( "Data/Characters/BipV3/Controllers/runState.rs" )
if (numchar > 1) :
    characters = instantChar.createMore()
    for ichar in range(0,numchar):
        controller = PyUtils.load( controlname.rstrip('\n'), characters[ichar] )
        controller.setStance( Core.LEFT_STANCE );
    instantChar.connectMoreController(False)
else :
    character = instantChar.create()
    controller = PyUtils.load( controlname.rstrip('\n'), character)
    controller.setStance( Core.LEFT_STANCE )
    instantChar.connectController(False) 

if (numchar == 1) : 	
	keyframeEditor = KeyframeEditor.Model()

## END
#####################

######################
## BEGIN DUMMY STUFF

#staircase = App.Scenario.Staircase( position=(0,0,5), rightRampHeight = 1, stepCount = 22, leftRampHeight = 1, angle = math.pi/4.0 )
#staircase.load()


#PyUtils.convertController("../../scoros5/data/controllers/bipV3/fWalk_3.sbc")

#ctrl2 = PyUtils.copy( app.getController(0), char )

## END DUMMY STUFF
######################

# Initial snapshot
app.takeSnapshot()

app.MainLoop()
app.Destroy()
