///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/**
 *	Contains code for random generators.
 *	\file		IceRandom.cpp
 *	\author		Pierre Terdiman
 *	\date		August, 9, 2001
 */
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#include "Opcode.h"

using namespace IceCore;

void IceCore::	SRand(udword seed)
{
	srand(seed);
}

udword IceCore::Rand()
{
	return rand();
}


static BasicRandom gRandomGenerator(42);

udword IceCore::GetRandomIndex(udword max_index)
{
	// We don't use rand() since it's limited to RAND_MAX
	udword Index = gRandomGenerator.Randomize();
	return Index % max_index;
}

