
#ifndef CALLGRAPH_H
#define CALLGRAPH_H

#include "llvm/IR/DataLayout.h"
#include "llvm/IR/DerivedTypes.h"
#include "llvm/IR/Module.h"
#include "llvm/Support/CallSite.h"
#include "llvm/Pass.h"

#include <unordered_map>
#include <unordered_set>
#include <vector>

namespace callgraphs {


struct WeightedCallGraphPass : public llvm::ModulePass {

  static char ID;

  // NOTE: Feel free to modify this class

  WeightedCallGraphPass()
    : ModulePass(ID)
      { }
  
  virtual ~WeightedCallGraphPass() { }

  virtual void getAnalysisUsage(llvm::AnalysisUsage &au) const override {
    au.setPreservesAll();
    au.addRequired<llvm::DataLayout>();
  }

  virtual void print(llvm::raw_ostream &out,
                     const llvm::Module *m) const override;

  virtual bool runOnModule(llvm::Module &m) override;
};


}

#endif
